//=============================================================================
//
// C [main.cpp]
// Author : KENSUKE WATANABE
//
//=============================================================================
#include "main.h"
#include "mode.h"
#include "modeTitle.h"
#include "modeGame.h"
#include "manager.h"
#include "renderer.h"
#include "scene2D.h"
#include "scene.h"

//*****************************************************************************
// }N`
//*****************************************************************************
#define CLASS_NAME		"AppClass"			// EChẼNX
#define WINDOW_NAME		"t[[N"	// EChẼLvV

//*****************************************************************************
// vg^Cv錾
//*****************************************************************************
LRESULT CALLBACK WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
void LoadFont(HINSTANCE hInstance);

#ifdef _DEBUG
int g_nCountFPS = 0;	// FPSJE^
#endif

//=============================================================================
// C֐
//=============================================================================
int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

	RECT cr = { 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT };	//EBhE̋`
	RECT dr;										//fXNgbv̋`

	AdjustWindowRect(&cr, WS_OVERLAPPEDWINDOW, FALSE);
	int ww = cr.right - cr.left;	//EBhE̕
	int wh = cr.bottom - cr.top;	//EBhE̍

									//fXNgbv̑傫擾
	GetWindowRect(GetDesktopWindow(), &dr);
	int dw = dr.right - dr.left;	//fXNgbv̕
	int dh = dr.bottom - dr.top;	//fXNgbv̍

	int wx = ww > dw ? 0 : (dw / 2) - (ww / 2);
	int wy = wh > dh ? 0 : (dh / 2) - (wh / 2);

	WNDCLASSEX wcex =
	{
		sizeof(WNDCLASSEX),
		CS_CLASSDC,
		WndProc,
		0,
		0,
		hInstance,
		nullptr,
		LoadCursor(nullptr, IDC_ARROW),
		(HBRUSH)(COLOR_WINDOW + 1),
		nullptr,
		CLASS_NAME,
		nullptr
	};
	RECT rect = {0, 0, SCREEN_WIDTH, SCREEN_HEIGHT};
	MSG msg;

	// EBhENX̓o^
	RegisterClassEx(&wcex);

	// w肵NCAg̈mۂ邽߂ɕKvȃEBhEWvZ
	AdjustWindowRect(&rect, WS_OVERLAPPEDWINDOW, false);

	// EBhE̍쐬
	HWND hWnd;
	hWnd = CreateWindowEx(0,	//gEBhEX^C
		CLASS_NAME,				//EBhENX̖O
		WINDOW_NAME,			//EBhE̖O	Q[
		WS_OVERLAPPEDWINDOW,	//EBhEX^C
		wx,						//EBhE̍X
		wy,						//EBhE̍Y
		ww,						//EBhE̕
		wh,						//EBhE̍
		nullptr,					//eEBhẼnh
		nullptr,					//j[nh܂͎qEBhẼnh
		hInstance,				//CX^Xnh
		nullptr);					//EBhE쐬f[^

	//EBhE̕\
	ShowWindow(hWnd, nCmdShow);	//w肳ꂽEBhE̕\	:EBhE̕\@w肷tO	nCmdShowł͂ȂŐݒ肵قS
	UpdateWindow(hWnd);			//EBhȄԂXV


	// }l[W[̐
	CManager *pManager = nullptr;
	pManager = new CManager();

	// 
	if (FAILED(pManager->Init(hInstance, hWnd, TRUE))) { return -1; }
	D3DXVECTOR2 screenSize = pManager->GetRenderer().GetScreenSize();
	// [h̐ݒ
	CManager::SetMode(new CModeTitle);

	LoadFont(hInstance);

	//eJE^̏
	DWORD dwFrameCount = 0;
	DWORD dwCurrentTime = 0;		//݂̎
	DWORD dwExecLastTime = timeGetTime();	//sI̎ timeGetTime():݂̎~bPʂŎ擾 Ɛx悭vꍇ̓}`fBA^C}[
	DWORD dwFPSLastTime = dwExecLastTime;	//dwExecLastTimeƓl

	//\̐ݒ
	timeBeginPeriod(1);

	//bZ[W[viQ[)
	for (;;)
	{
		if (PeekMessage(&msg, nullptr, 0, 0, PM_REMOVE) != 0)
		{
			//Window̏
			if (msg.message == WM_QUIT)
			{
				break;
			}
			else
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
		else
		{//PeekMessageɃbZ[WĂȂ
			dwCurrentTime = timeGetTime();	//݂̃VXe擾
#ifdef _DEBUG
			if ((dwCurrentTime - dwFPSLastTime) >= 500)
			{
				g_nCountFPS = (dwFrameCount * 1000) / (dwCurrentTime - dwFPSLastTime);
				dwFPSLastTime = dwCurrentTime;
				dwFrameCount = 0;
			}
#endif
			if ((dwCurrentTime - dwExecLastTime) >= (1000 / 60))
			{// 1000/60bȏソĂ
				dwExecLastTime = dwCurrentTime;	//XV

				// XV
				pManager->Update(hWnd);

				// `揈
				pManager->Draw();
				dwFrameCount++;
			}
		}
	}

	// IuWFNg̔j
	if(pManager != nullptr)
	{
		pManager->Uninit();
	}
	delete pManager;
	pManager = nullptr;

	// EBhENX̓o^
	UnregisterClass(CLASS_NAME, wcex.hInstance);

	timeEndPeriod(1);	//^C}\ɖ߂

	return (int)msg.wParam;
}

//=============================================================================
// vV[W
//=============================================================================
LRESULT CALLBACK WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	LPDIRECT3DDEVICE9 dev = CManager::GetRenderer().GetDevice();

	switch(uMsg)
	{
	case WM_CREATE:
		break;
	
		// -------- }EXJ[\
	case WM_SETCURSOR:
		// Turn off window cursor 
		SetCursor(nullptr);
		dev->ShowCursor(TRUE);
		return TRUE; // prevent Windows from setting cursor to window class cursor
		break;

	case WM_DESTROY:
		PostQuitMessage(0);
		break;

	case WM_KEYDOWN:
		switch(wParam)
		{
		case VK_ESCAPE:					// [ESC]L[ꂽ
			DestroyWindow(hWnd);		// EBhEj悤w
			break;
		}
		break;

	default:
		break;
	}

	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}

// -------- tHg̓ǂݍ
void LoadFont(HINSTANCE hInstance)
{
	HRSRC resource = FindResource(hInstance, "PixelMplus12-Regular", RT_RCDATA);
	LPVOID font = LockResource(resource);
	DWORD size = SizeofResource(nullptr, resource);
	DWORD fontCount = 0;
	AddFontMemResourceEx(font, size, nullptr, &fontCount);
}

#ifdef _DEBUG
//=============================================================================
// FPSݒ
//=============================================================================
int GetFPS(void)
{
	return g_nCountFPS;
}
#endif